/*
 * Decompiled with CFR 0.152.
 */
package com.articles.service;

import com.articles.repo.TagRepo;
import com.articles.repo.domain.Tag;
import com.articles.service.TagService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class TransactionalTagService
implements TagService {
    private final TagRepo tagRepo;

    public void saveAll(List<Tag> tags) {
        for (Tag tag : tags) {
            this.save(tag);
        }
    }

    public Optional<Tag> findByTitle(String title) {
        return this.tagRepo.findByTitle(title);
    }

    public Tag save(Tag tag) {
        return this.tagRepo.findByTitle(tag.getTitle()).orElseGet(() -> (Tag)this.tagRepo.save((Object)new Tag(tag.getTitle())));
    }

    public TransactionalTagService(TagRepo tagRepo) {
        this.tagRepo = tagRepo;
    }
}

