/*
 * Decompiled with CFR 0.152.
 */
package com.articles.web.rest;

import com.articles.repo.domain.Topic;
import com.articles.service.TopicService;
import com.articles.web.Validator;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/topic"})
public class TopicResource {
    private final Validator validator;
    private final TopicService topicService;

    @PostMapping
    public void addTopics(@RequestBody Topic topic, @RequestHeader String string) {
        if (this.validator.validate(string)) {
            this.topicService.addTopics(topic);
        }
    }

    @GetMapping
    public List<Topic> getAllTopics(@RequestHeader String string) {
        if (this.validator.validate(string)) {
            return this.topicService.getAll();
        }
        return new ArrayList<Topic>();
    }

    public TopicResource(Validator validator, TopicService topicService) {
        this.validator = validator;
        this.topicService = topicService;
    }
}

