/*
 * Decompiled with CFR 0.152.
 */
package com.articles.service;

import com.articles.repo.domain.Article;
import com.articles.service.ArticleService;
import com.articles.web.dto.ChapterDTO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SitemapService {
    private final ArticleService articleService;
    private static final String BASE_URL = "https://topiqs.net";

    public String getSitemap() {
        StringBuilder sitemapBuilder = new StringBuilder();
        sitemapBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sitemapBuilder.append("<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sitemapBuilder.append("  <url>\n");
        sitemapBuilder.append("    <loc>").append(BASE_URL).append("/</loc>\n");
        sitemapBuilder.append("    <lastmod>").append(LocalDateTime.now().format(formatter)).append("</lastmod>\n");
        sitemapBuilder.append("    <changefreq>daily</changefreq>\n");
        sitemapBuilder.append("    <priority>1.0</priority>\n");
        sitemapBuilder.append("  </url>\n");
        List chapters = this.articleService.findAllUniqueChapters();
        for (ChapterDTO chapter : chapters) {
            String chapterUrl = "https://topiqs.net/articles/chapter/" + String.valueOf(chapter.getChapter());
            sitemapBuilder.append("  <url>\n");
            sitemapBuilder.append("    <loc>").append(chapterUrl).append("</loc>\n");
            sitemapBuilder.append("    <lastmod>").append(LocalDateTime.now().format(formatter)).append("</lastmod>\n");
            sitemapBuilder.append("    <changefreq>weekly</changefreq>\n");
            sitemapBuilder.append("    <priority>0.8</priority>\n");
            sitemapBuilder.append("  </url>\n");
        }
        List allArticles = this.articleService.getAll();
        for (Article article : allArticles) {
            String articleUrl = "https://topiqs.net/articles/" + article.getId();
            sitemapBuilder.append("  <url>\n");
            sitemapBuilder.append("    <loc>").append(articleUrl).append("</loc>\n");
            sitemapBuilder.append("    <lastmod>").append(article.getLastModified()).append("</lastmod>\n");
            sitemapBuilder.append("    <changefreq>daily</changefreq>\n");
            sitemapBuilder.append("    <priority>0.9</priority>\n");
            sitemapBuilder.append("  </url>\n");
        }
        sitemapBuilder.append("</urlset>");
        return sitemapBuilder.toString();
    }

    public SitemapService(ArticleService articleService) {
        this.articleService = articleService;
    }
}

